import processing.opengl.*;
import toxi.geom.*;
import toxi.math.*;
import codeanticode.protablet.*;
import javax.swing.*;

//hardware
Tablet tablet;

//editor
boolean mark_recording = false;
boolean render_interface = true;
boolean move_mark_preview = false;
boolean sync_recording = false;
boolean replace_recording = false;
boolean drag = false;
boolean paused = false;
boolean crop = false;
boolean allowEnter = true;
PFont font;
int modifiers;
String loaded_mark = "";
static mark selected_mark;
ArrayList <mark> selected_marks = new ArrayList();


//sequencer
int transition_timer = 0;
int transition_timer_interval = 50;
int fade = 255;
int temp_fade = 0;

//recorder
boolean trail = false;
boolean horizontal_lock = false;
boolean vertical_lock = false;
float[][] recorded_steps;
float pressure = 0;
float rotation = 0;
float tilt_x = 0;
float tilt_y = 0;
float delay = 0;
int selected_step_mode = 2;
int first_flag = 0;
int second_flag = 0;
int third_flag = 0;
Vec2D recorded_local_origin;
Vec2D recorded_global_origin;

//root_mark data
ArrayList <mark> root_marks = new ArrayList <mark> ();
ArrayList <mark> playing_roots = new ArrayList <mark> ();
ArrayList <mark> played_roots = new ArrayList <mark> ();

ArrayList <mark> marks = new ArrayList();

mark root_mark;

void setup() 
{

  size(850, 850, OPENGL); 
  noSmooth();
  hint(DISABLE_OPENGL_2X_SMOOTH);
  frameRate(60);

  strokeWeight(1);

  noFill();
  ellipseMode(CENTER);
  rectMode(CENTER);
  imageMode(CENTER);

  PImage c;
  c = loadImage("cursor.png");
  cursor(c);

  font = loadFont("Monospaced-10.vlw");
  textFont(font, 10);

  tablet = new Tablet(this);
  println(tablet);

  root_marks.add(new mark("root", null, null, new Vec2D(0, 0), new Vec2D(width/2, height/2), false, false, "bidirectional"));
  root_mark = root_marks.get(0);
  selected_mark = root_mark;
  root_mark.parent_mark = root_mark;
  root_mark.current_position = new Vec2D(width/2, height/2);
  playing_roots.add(root_mark);
  root_marks.remove(root_mark);

  //load_all();
}

/* todo
 
 */

void draw() {

  composition_sequencer();
  if (crop) {
    background(255);
    stroke(50);
    fill(0);
    rect(width/2, height/2, 800, 800);
    noFill();
  } 
  else background(0);
  if (mark_recording) {
    record_mark();
  }
  if (render_interface) {
    stroke(60);
    rect(root_mark.local_origin.x, root_mark.local_origin.y, 20, 20);
    point(root_mark.local_origin.x, root_mark.local_origin.y);
  }
  for (mark root : playing_roots) {
    if (playing_roots.size() > 1 && root == playing_roots.get(1)) temp_fade = 255-fade;
    else temp_fade = fade;
    marks = get_marks(root, new ArrayList());
    step_marks(marks);
    //Collections.reverse(marks);
    if (render_interface==false) render_mark_display(marks);
    else {
      render_mark_preview(marks);
      render_mark_lines(marks);
      render_mark_nodes(marks);
    }
  }
}

//timing and sequencing

void composition_sequencer() {

  if (playing_roots.size() == 2) {
    if (millis() - transition_timer > transition_timer_interval) {
      transition_timer_interval = int(random(50, 100));
      if (fade < 255) {
        fade++;
      }
      else {
        fade = 0;  
        if (root_marks.size() == 0 && played_roots.size() == 0) {
          mark m = playing_roots.remove(1);
          playing_roots.add(0, m);
        } 
        else if (root_marks.size() == 0 && played_roots.size() != 0) {
          root_marks.addAll(played_roots);
          played_roots.clear();
        }
        if (root_marks.size() != 0) {
          played_roots.add(playing_roots.remove(1));
          mark m = root_marks.get(int(random(root_marks.size())));
          root_marks.remove(m);
          playing_roots.add(0, m);
        }
      }
      transition_timer = millis();
    }
  }
}

void step_marks(ArrayList <mark> marks) {

  for (mark m : marks) {
    m.previous_position = m.current_position;
    Vec2D position = new Vec2D(m.steps[m.i][0], m.steps[m.i][1]);
    if (paused || m.paused) {
    }
    else if (m.delay < m.steps[m.i][6]) {
      m.delay++;
    } 
    else position = m.step(m.step_mode);
    if (m.inherit_motion) {
      m.current_position = position.add(m.local_origin).add(m.parent_mark.current_position);
    }
    else {
      m.current_position = position.add(m.local_origin).add(m.parent_mark.local_origin);
    }
  }
}

ArrayList get_marks(mark parent, ArrayList <mark> marks) {

  for (mark m : parent.marks) {
    marks.add(m);
    get_marks(m, marks);
  }
  return marks;
}

// rendering 

void render_mark_display(ArrayList <mark> marks) {

  for (mark m : marks) {

    int num_parents = m.num_parents(m, 0);
    float pressure = temp_fade-m.steps[m.i][2]*(temp_fade);
    stroke(255, pressure);

    if (m.trail) {
      beginShape(); 
      for (int n = 0; n <= m.steps.length-1; n++) {  
        Vec2D line_segment = new Vec2D(m.steps[n][0]+m.local_origin.x+m.parent_mark.current_position.x, m.steps[n][1]+m.local_origin.y+m.parent_mark.current_position.y);       
        pressure = temp_fade-m.steps[n][2]*(temp_fade);
        stroke(255, pressure);
        if (n > m.i) {
        }
        else vertex(line_segment.x, line_segment.y);
      }
      endShape();
    }
    else {
      if (m.mark_image != null) image(m.mark_image, m.current_position.x, m.current_position.y);
      point(m.current_position.x, m.current_position.y, 0);
    }
  }
}

void render_mark_preview(ArrayList <mark> marks) {

  for (mark m : marks) {
    int fade_value = 40;
    if (m.trail) fade_value = 60;
    beginShape(); 
    for (int n = 0; n <= m.steps.length-1; n++) {  
      Vec2D line_segment = new Vec2D(m.steps[n][0]+m.local_origin.x+m.parent_mark.current_position.x, m.steps[n][1]+m.local_origin.y+m.parent_mark.current_position.y);       
      pressure = fade_value-m.steps[n][2]*(fade_value);
      stroke(255, pressure);
      if (n < m.i) {
        stroke(255, pressure*2);
      }
      vertex(line_segment.x, line_segment.y);
    }
    endShape();
  }
}

void render_mark_lines(ArrayList <mark> marks) {

  for (mark m : marks) {
    int num_parents = m.num_parents(m, 0);
    if (m == selected_mark) {
      stroke(0, 100, 0, 200);
      if (playing_roots.contains(m.parent_mark)==false) {
        line(m.current_position.x, m.current_position.y, m.parent_mark.current_position.x, m.parent_mark.current_position.y);
      }
    }
    else if (playing_roots.contains(m.parent_mark)==false) {
      float d = m.current_position.distanceTo(m.parent_mark.current_position)/6;
      stroke(255/(num_parents)+50, 0, 0, 255);
      for (int i=0; i<=d; i++) {
        Vec2D interpolated_point = m.current_position.interpolateTo(m.parent_mark.current_position, i/d);
        point(interpolated_point.x, interpolated_point.y);
      }
    }
  }
}

void render_mark_nodes(ArrayList <mark> marks) {

  for (mark m : marks) {
    int num_parents = m.num_parents(m, 0);
    stroke(255, 50);

    if (num_parents == 1) {
      stroke(200, 200, 0);
      ellipse(m.current_position.x, m.current_position.y, 8, 8);
      stroke(255);
    }
    if (move_mark_preview) {
      for (mark c : m.parent_mark.marks) {
        if (c.marks.contains(selected_mark)) {
          stroke(0, 170, 0, 255);
        }
      }
      if (m.parent_mark.parent_mark.marks.contains(selected_mark.parent_mark) && m.parent_mark.marks.indexOf(m) == 0 && m != selected_mark) {
        fill(100, 0, 100);
      }
      if (m == selected_mark.parent_mark.parent_mark) {
        fill(200, 0, 200);
      }
    }
    else {  
      if (m.parent_mark == selected_mark.parent_mark) {
        stroke(0, 170, 0, 255);
      }
      if (m == selected_mark.parent_mark) {
        fill(200, 0, 200);
      }
      else if (selected_mark.marks.size() > 0 && m == selected_mark.marks.get(0)) {
        fill(100, 0, 100);
      }
      else {
        fill(75);
      }
    }
    ellipse(m.current_position.x, m.current_position.y, num_parents+2, num_parents+2);

    // add text && image
    fill(255, 20);
    noStroke();
    if (m.mark_image != null) rect(m.current_position.x, m.current_position.y, m.mark_image.width, m.mark_image.height);
    fill(255);
    text(m.name, int(m.current_position.x+10+(num_parents*2)), int(m.current_position.y+10+(num_parents*2)));

    // add flags 789
    fill(255, 255, 0);
    String step_text = "[F]";
    if (m.steps[m.i][7] == 1) step_text += " 1";
    if (m.steps[m.i][8] == 1) step_text += " 2";
    if (m.steps[m.i][9] == 1) step_text += " 3";
    if (step_text != "[F]") text(step_text, int(m.current_position.x+10+(num_parents*2)), int(m.current_position.y+20+(num_parents*2)));
    noFill();

    if (m == selected_mark) {
      stroke(255, 200); 
      ellipse(m.current_position.x, m.current_position.y, num_parents+12, num_parents+12);
      noStroke();
      fill(255, 200, 200, 80);
      Vec2D mouse = mark_to_mouse(m);
      ellipse(mouse.x+m.current_position.x, mouse.y+m.current_position.y, num_parents+2, num_parents+2);
      noFill();
    }
    if (selected_marks.contains(m)) {
      stroke(255, 0, 0);
      ellipse(m.current_position.x, m.current_position.y, num_parents+14, num_parents+14);
      noStroke();
    }
  }
}

// mouse and keyboard

void mousePressed() {
  recorded_local_origin = mark_to_mouse(selected_mark);
  recorded_global_origin = mouse_vector();
  recorded_steps = new float[0][0];

  switch(mouseButton) {

  case LEFT:
    mark_recording=true;
    if (modifiers == 64) {
      replace_recording = true;
    }
    break;

  case RIGHT:
    if (selected_mark != root_mark) {
      sync_recording = true; 
      mark_recording = true;
    }
    break;

  case CENTER:
    if (selected_mark != root_mark) {
      replace_recording = true;
      mark_recording = true;
    }
    break;
  }
}   

void mouseMoved() {

  if (drag) {  
    if (selected_marks.size() > 0) {
      for (mark m : selected_marks) {
        m.local_origin = mouse_vector().add(m.offset);
      }
    } 
    else selected_mark.local_origin = mouse_vector().add(selected_mark.offset);

    if (selected_mark == root_mark) {
      root_mark.current_position = root_mark.local_origin;
    }
    else if (selected_mark != root_mark ) {
      mark s = closest_mark(selected_mark, mouse_distances(root_mark, new ArrayList[0]));
      line(s.current_position.x, s.current_position.y, selected_mark.current_position.x, selected_mark.current_position.y);
    }
  }
}

void mouseReleased() {

  if (mouseButton == LEFT || mouseButton == CENTER) {
    complete_mark();
  }
}

void keyPressed() {

  modifiers = keyEvent.getModifiersEx();

  switch(key) {

  case '1':
    load_all();
    break;

  case ' ':
    drag=true;
    selected_mark.offset = selected_mark.local_origin.sub(mouse_vector());
    for (mark m : selected_marks) {
      m.offset = m.local_origin.sub(mouse_vector());
    }

    break;  

  case '0':
    for (mark m : marks) {
      m.i = 0;
    }
    break;

  case '/':
    if (selected_mark != root_mark) { 
      selected_mark.remove_from_parent();
      selected_mark.parent_mark = root_mark;
      root_mark.add_mark(selected_mark);
      selected_mark.local_origin = mouse_vector();
    }
    break;

  case '+':
  case '=':
    if (selected_mark != root_mark) {
      selected_mark.step("forward");
    }
    break;

  case '-':
    if (selected_mark != root_mark) {
      selected_mark.step("backward");
    }
    break;

  case '*':
    selected_mark.paused=!selected_mark.paused;
    break;

  case 'm':
    selected_mark.paused=!selected_mark.paused;
    break;

  case 'z':
    selected_step_mode+=1;
    if (selected_step_mode > 2) {
      selected_step_mode=0;
    }
    selected_mark.step_mode = selected_mark.step_modes[selected_step_mode];
    break;  

  case 'a':
    selected_marks = new ArrayList();
    selected_mark = mouse_pick(root_mark, root_mark);
    break;

  case 'A':
    selected_marks.add(mouse_pick(root_mark, root_mark));
    break;

  case '`':
    set_origin_mark(selected_mark);
    break;

  case 'i':
    print("local origin - "+selected_mark.local_origin+" current_position - "+selected_mark.current_position+" name - "+selected_mark.name+"\n");
    break;

  case 't':
    trail=!trail;
    selected_mark.trail=!selected_mark.trail;
    break;

  case 'x':
    root_mark.local_origin = new Vec2D(width/2, height/2);
    break;

  case 'q':
    first_flag = 1;
    break;

  case 'w':
    second_flag = 1;
    break;

  case 'e':
    third_flag = 1;
    break;

  case '[':
    selected_mark.parent_mark.lower_mark(selected_mark);
    break;

  case ']':
    selected_mark.parent_mark.raise_mark(selected_mark);
    break;

  case 'b':
    vertical_lock=!vertical_lock;
    break;

  case 'v':
    horizontal_lock=!horizontal_lock;
    break;
  }

  switch(keyCode) {

  case CONTROL:
    render_interface=!render_interface;
    break;

  case SHIFT:
    if (drag==false) {
      move_mark_preview=true;
    }
    else if (drag) {
      selected_mark.move_mark(mouse_distances(root_mark, new ArrayList[0]));
    }
    break;

  case ALT:
    paused=!paused;
    break;  

  case UP:
    if (modifiers==64) {
      selected_mark.move_mark_longitudinal("ascend");
    } 
    else selected_mark = selected_mark.parent_mark;
    break;

  case DOWN:
    if (modifiers==64) {
      selected_mark.move_mark_longitudinal("descend");
    }
    else {
      if (selected_mark.marks.size() > 0) {
        selected_mark = selected_mark.marks.get(0);
      }
    }
    break;

  case LEFT:
    if (modifiers==64) {
      selected_mark.move_mark_lateral("prev");
    }
    else selected_mark = selected_mark.prev_mark();
    recorded_local_origin = mark_to_mouse(selected_mark);
    break;

  case RIGHT:
    if (modifiers==64) {
      selected_mark.move_mark_lateral("next");
    }
    else selected_mark = selected_mark.next_mark();
    recorded_local_origin = mark_to_mouse(selected_mark);
    break;

  case BACKSPACE:
    if (selected_mark != root_mark) {
      selected_mark.remove_from_parent();
      if (selected_mark.parent_mark.marks.size() > 0) {
        selected_mark = selected_mark.prev_mark();
      } 
      else selected_mark = root_mark;
    }
    break;

  case TAB:
    crop=!crop;
    break;

  case ENTER:
    if (modifiers==64) {
      noLoop();
      loaded_mark = selectInput();
      load_mark(loaded_mark);
      loop();
      modifiers=0;
    }
    else export_mark(selected_mark);
    break;
  }
} 

void keyReleased() {

  switch(key) {

  case ' ':
    drag=false;
    break;

  case 'q':
    first_flag = 0;
    break;

  case 'w':
    second_flag = 0;
    break;

  case 'e':
    third_flag = 0;
    break;
  }

  switch(keyCode) {

  case SHIFT:
    move_mark_preview=false;
    break;
  }
}

void keyTyped() {

  switch(key) {

  case 'l':
    if (selected_mark != root_mark) {
      thread("load_mark_image");
    }
    break;

  case 'n':
    if (selected_mark != root_mark) {
      java.awt.EventQueue.invokeLater(new Runnable() {
        public void run() {
          String new_name = JOptionPane.showInputDialog("What is this animation's name?");
          if (new_name != null) selected_mark.name = new_name;
        }
      }
      );
    }
    break;
  }
}

//mark functions

void record_mark() {

  rotation = tablet.getRotation();
  pressure = tablet.getPressure();
  tilt_x = tablet.getTiltX();
  tilt_y = tablet.getTiltY();
  float x = tablet.getPenX();
  float y = tablet.getPenY();

  if (horizontal_lock) x = 0;
  if (vertical_lock) y = 0;

  float[] step = {
    x - recorded_global_origin.x, y - recorded_global_origin.y, pressure, rotation, tilt_x, tilt_y, 0, 
    first_flag, second_flag, third_flag
  };
  if (recorded_steps.length == 0) {
    recorded_steps = (float[][]) append(recorded_steps, step);
  }
  else if (Arrays.equals(step, recorded_steps[recorded_steps.length-1])) {
    delay++;
  } 
  else {
    step[6] = delay; 
    delay = 0; 
    recorded_steps = (float[][]) append(recorded_steps, step);
  }

  if (sync_recording && recorded_steps.length == selected_mark.steps.length) {
    sync_recording=false;
    mark_recording=false;
    complete_mark();
  }

  beginShape(); 
  for (int n = 0; n < recorded_steps.length-1; n++) {
    Vec2D line_segment = new Vec2D(recorded_steps[n][0]+selected_mark.current_position.x+recorded_local_origin.x, recorded_steps[n][1]+selected_mark.current_position.y+recorded_local_origin.y);
    stroke(150, 255, 150, 100-recorded_steps[n][2]*100);
    vertex(line_segment.x, line_segment.y);
  }
  endShape();
}

void complete_mark() {

  mark_recording=false;
  if (recorded_steps.length > 2 && replace_recording == false) {
    mark m = new mark(str(millis()), recorded_steps, selected_mark, recorded_global_origin, recorded_local_origin, trail, false, root_mark.step_modes[selected_step_mode]);
    selected_mark.add_mark(m);
  } 
  else if (recorded_steps.length > 2 && replace_recording) {
    selected_mark.i = 0;
    selected_mark.global_origin = recorded_global_origin;
    selected_mark.steps = recorded_steps;
    replace_recording = false;
  }
  else recorded_steps = null;
}

//coordinate, distance and mouse functions

Vec2D mouse_vector() {

  return new Vec2D(mouseX, mouseY);
}

Vec2D mark_to_mouse(mark m) {

  return mouse_vector().sub(mark_coordinates(m, m.local_origin));
} 

Vec2D mark_coordinates(mark m, Vec2D i) {

  if (m != root_mark) { 
    i = i.add(m.parent_mark.local_origin);
    m = m.parent_mark;
    return mark_coordinates(m, i);
  }
  else return i;
}

mark mouse_pick(mark level, mark pick) {

  for (mark m : level.marks) {
    if (m.current_position.sub(mouse_vector()).compareTo(new Vec2D(9, 9)) < 10) {
      pick = m;
      break;
    }
    pick = mouse_pick(m, pick);
  }

  return pick;
}

ArrayList[] mouse_distances(mark level, ArrayList[] distances) {

  for (mark m : level.marks) {

    if (m!=selected_mark && m!=selected_mark.parent_mark && selected_mark.marks.contains(m) == false && mark_contains(selected_mark, m, false) == false) { //is in tree?
      ArrayList a = new ArrayList(2);
      a.add(m);
      a.add(new Float(m.current_position.distanceTo(selected_mark.current_position)));
      distances = (ArrayList[]) append(distances, a);
    }  
    distances = mouse_distances(m, distances);
  }
  return distances;
}


void set_origin_mark(mark new_origin) {

  mark old_origin = get_origin_mark(new_origin);
  mark[] parents = get_parent_marks(new_origin, new mark[0]);
  Vec2D saved_new_origin = new_origin.local_origin;
  new_origin.local_origin = (mark_coordinates(new_origin, new_origin.local_origin)).sub(root_mark.local_origin);
  new_origin.parent_mark.marks.remove(new_origin);
  root_mark.add_mark(new_origin);

  for (mark p : parents) {
    p.parent_mark.marks.remove(p);
  }

  Vec2D saved_origin = saved_new_origin;

  for (int i = parents.length-1; i >= 0; i--) {
    if (i == parents.length-1) {
      new_origin.add_mark(parents[i]);
      saved_origin = parents[i].local_origin;
      parents[i].local_origin = saved_new_origin;
    }
    else {
      parents[i+1].add_mark(parents[i]);
      Vec2D temp_saved_origin = parents[i].local_origin;
      parents[i].local_origin = saved_origin;
      saved_origin = temp_saved_origin;
    }
    parents[i].local_origin = new Vec2D(0, 0).sub(parents[i].local_origin);
  }
}

mark get_origin_mark(mark m) {

  if (m.parent_mark != root_mark) {
    m = m.parent_mark;
    return get_origin_mark(m);
  } 
  else return m;
}

mark[] get_children_marks(mark parent, mark[] children) {

  for (mark child : parent.marks) {
    children = (mark[]) append(get_children_marks(child, children), child);
  } 
  return children;
}

mark[] get_parent_marks(mark child, mark[] parents) {

  if (child.parent_mark != root_mark) { 
    parents = (mark[]) append(get_parent_marks(child.parent_mark, parents), child.parent_mark);
  }
  return parents;
}

mark closest_mark(mark m, ArrayList[] distances) {

  float[] distance_values = new float[0];
  mark[] marks = new mark[0];

  if (distances.length == 0) {
    return root_mark;
  }  
  for (ArrayList a : distances) {
    distance_values = (float[]) append(distance_values, a.get(1));
    marks = (mark[]) append(marks, a.get(0));
  }
  for (ArrayList a : distances) {
    if (sort(distance_values)[0] == (Float) a.get(1)) {  
      m = (mark) a.get(0);
    }
  }
  return m;
}

boolean mark_contains(mark haystack, mark needle, boolean tf) {

  for (mark m : haystack.marks) {
    if (m != needle) {
      tf = mark_contains(m, needle, tf);
    } 
    else tf = true;
  }
  return tf;
}

ArrayList mark_to_XML(ArrayList <mark> marks, ArrayList XML) {

  for (mark m : marks) {
    String mark_tag = "<mark "+join(new String[] {
      "name='"+m.name+"'", "local_origin_x='"+str(m.local_origin.x)+"'", "local_origin_y='"+str(m.local_origin.y)+"'", "global_origin_x='"+str(m.global_origin.x)+"'", "global_origin_y='"+str(m.global_origin.y)+"'", "step_mode='"+m.step_mode+"'", "trail='"+str(m.trail)+"'", "paused='"+str(m.paused)+"'"
    }
    , " ")+">";

    String steps_tag = "<steps i='"+str(m.i)+"'>";
    XML.add(mark_tag);
    XML.add(steps_tag);

    for (float[] s : m.steps) {
      String step = "<step x='"+nfp(s[0], 3, 8)+"' y='"+nfp(s[1], 3, 8)+"' p='"+nfp(s[2], 0, 14)+"' r='"+nfp(s[3], 0, 14)+"' tx='"+nfp(s[4], 0, 14)+"' ty='"+nf(s[5], 0, 14)+"' d='"+nfp(s[6], 0, 0)+"' f1='"+nfp(s[7], 0, 0)+"' f2='"+nfp(s[8], 0, 0)+"' f3='"+nfp(s[9], 0, 0)+"' />";
      XML.add(step);
    }

    XML.add("</steps>");
    XML = (mark_to_XML(m.marks, XML));
    XML.add("</mark>");
  }
  return XML;
}

void export_mark(mark m) {

  ArrayList <String> XML = mark_to_XML(m.marks, new ArrayList <String> ());

  XML.add(0, "<composition>"); //root mark
  XML.add("</composition>"); // root mark

  String[] output = new String[0];

  output = XML.toArray(output);

  if (loaded_mark == "") saveStrings(year()+"_"+month()+"-"+day()+"_"+hour()+"-"+minute()+".XML", output);
  else saveStrings(loaded_mark, output);
}

void load_mark_image() {
  String file = selectInput();
  if (file != null) {
    selected_mark.mark_image = loadImage(file);
  }
}

mark load_mark(String composition) {

  XMLElement XML = new XMLElement(this, composition);
  mark new_root = new mark(XML.getString("name"), null, null, new Vec2D(0, 0), new Vec2D(width/2, height/2), false, false, "bidirectional");
  new_root.parent_mark = new_root;

  if (playing_roots.size() == 1 && root_mark.marks.size() > 0) {  
    playing_roots.add(new_root);
  } 
  else if ( root_mark.marks.size() == 0) {
    new_root = root_mark;
    playing_roots.clear();
    playing_roots.add(new_root);
  } 
  else {
    root_marks.add(new_root);
  }

  XMLElement[] elements = XML.getChildren();

  for (XMLElement e : elements) {
    String name = e.getName();
    mark new_mark = new mark(e.getString("name"), new float[0][0], new_root, new Vec2D(e.getInt("global_origin_x"), e.getInt("global_origin_y")), new Vec2D(e.getInt("local_origin_x"), e.getInt("local_origin_y")), boolean(e.getString("trail")), boolean(e.getString("paused")), e.getString("step_mode"));
    new_mark.paused = boolean(e.getString("paused"));
    load_mark_loop(e.getChildren(), new_mark);
  }
  return new_root;
}


void load_mark_loop(XMLElement[] children, mark new_mark) {

  for (XMLElement child : children) {
    String name = child.getName();

    if (name.equals("steps")) {
      new_mark.i = child.getInt("i");
      XMLElement[] steps = child.getChildren();

      for (XMLElement step : steps) {
        float[] new_step = {
          step.getFloat("x"), step.getFloat("y"), step.getFloat("p"), step.getFloat("r"), step.getFloat("tx"), step.getFloat("ty"), step.getFloat("d"), step.getInt("f1"), step.getInt("f2"), step.getInt("f3")
          };
          new_mark.steps = (float[][]) append(new_mark.steps, new_step);
      }
      new_mark.parent_mark.marks.add(new_mark);
    }
    else if (name.equals("mark")) {
      mark newer_mark = new mark(child.getString("name"), new float[0][0], new_mark, new Vec2D(child.getInt("global_origin_x"), child.getInt("global_origin_y")), new Vec2D(child.getInt("local_origin_x"), child.getInt("local_origin_y")), boolean(child.getString("trail")), boolean(child.getString("paused")), child.getString("step_mode"));
      load_mark_loop(child.getChildren(), newer_mark);
    }
  }
}

void load_all() {

  File file = new File(sketchPath("finished_lines"));
  String file_names[] = file.list();
  String compositions[] = subset(file_names, 1);
  ArrayList <String> compositions_shuffled = new ArrayList();

  for (int i = 0; i <= compositions.length-1; i++) {
    compositions_shuffled.add(compositions[i]);
  }

  Collections.shuffle(compositions_shuffled);

  for (String composition : compositions_shuffled) {
    load_mark(sketchPath("finished_lines/")+composition);
  }
}

